﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Telerik.Web.UI;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using System.Collections;

public partial class ReportRandRCareReport : System.Web.UI.Page
{

    #region Variable Declarations

    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private UserAccountManager _currentUser; 
    string _reportName = "RandRCareSummaryReport";
    string _facilityChosen = String.Empty;

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            if (!IsPostBack)
            {
                DateFrom.Date.Text = "1/1/2012";
                lblReportTitle.Visible = false;
            }
        
            if (Request.QueryString["RunReport"] == "1")
            {
                lblReportTitle.Visible = false;
                rdgrdPatTreatment.Visible = false;
                btnReturn.Visible = true;
                rgGetRRPatients.Visible = true;
                //lbl2.Visible = true;
                if (Request.QueryString["RunReport"] != null)
                {
                    _facilityChosen = Request.QueryString["FacID"].ToString();
                }
                DateTime? _startDate = null;
                DateTime? _endDate = null;
                if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null)
                {
                    _startDate = Convert.ToDateTime(DateFrom.DateValue);
                }
                if (DateTo.DateValue.Length == 0 || DateTo.DateValue == null)
                {
                    if (DateTo.DateValue.ToString() != ""){ _endDate = Convert.ToDateTime(DateTo.DateValue); }
                }
                PopulatrgGetRRPatientsOnDataSource(_startDate, _endDate, _facilityChosen);
            }
            else
            {
                SetReportParameters();
            }
        }
        else
        {
            //Response.Redirect("~/ErrorPage.aspx?id=100");
        }
    }

    #endregion
    
    void Page_PreRender(object sender, EventArgs e)
    {
        if (Session["RandRFromReportFromDate"] != null) { DateFrom.DateValue = Session["RandRFromReportFromDate"].ToString(); }
        if (Session["RandRFromReportToDate"] != null) { DateTo.DateValue = Session["RandRFromReportToDate"].ToString(); }
    }
    protected void GridViewOnNeedOfDataSource(object sender, GridNeedDataSourceEventArgs e)
    {
        SetReportParameters();
    }

    private void PopulateRdgrdPatTreatmentOnDataSource(DateTime? startDate, DateTime? endDate )
    {
        System.Data.DataTable dataTableGrid = SqlProvider.ExecuteSPDataTable(
                    "RegistryConnectionString", "[TBI].[GetRehabilitationAndReIntegretionCarePlan]",
                    new object[] { startDate, endDate });

        if (dataTableGrid != null)
        {
            rdgrdPatTreatment.DataSource = dataTableGrid;
            rdgrdPatTreatment.DataBind();
        }
        btnReturn.Visible = false;
       // lbl2.Visible = false;
    }

    protected void GridViewOnNeedOfPPDataSource(object sender, GridNeedDataSourceEventArgs e)
    {
        //SetReportParameters();
    }

    private void PopulatrgGetRRPatientsOnDataSource(DateTime? startDate, DateTime? endDate, string facilityid)
    {
        System.Data.DataTable dataTableGrid = SqlProvider.ExecuteSPDataTable(
                "RegistryConnectionString", "[TBI].[GetAllRandRPatientCareSurvies]",
                new object[] { startDate, endDate, facilityid });

        if (dataTableGrid != null)
        {
            rgGetRRPatients.DataSource = dataTableGrid;
            rgGetRRPatients.DataBind();
        }
    }
    protected void btnReturn_Click(object sender, EventArgs e)
    {
        rdgrdPatTreatment.Visible = true;
        rgGetRRPatients.Visible = false;
        if (Session["RandRFromReportFromDate"] != null) { DateFrom.DateValue = Session["RandRFromReportFromDate"].ToString(); }
        if (Session["RandRFromReportToDate"] != null) { DateTo.DateValue = Session["RandRFromReportToDate"].ToString(); }

        SetReportParameters();
       
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null || DateTo.DateValue.Length == 0 || DateTo.DateValue == null)
        {
            if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null)
            {
                lblDateValidation.Visible = true;
                DateFrom.Focus();
                
            }
            if (DateTo.DateValue.Length == 0 || DateTo.DateValue == null)
            {
                if (IsPostBack)
                {
                    lblDateValidation2.Visible = true;
                    DateTo.Focus();
                }
            }
            if (DateFrom.DateValue.Length > 0 && DateTo.DateValue.Length > 0)
            {
                if (Convert.ToDateTime(DateTo.DateValue) > Convert.ToDateTime(DateFrom.DateValue))
                {
                    lblDateValidation3.Visible = true;
                    DateFrom.Focus();
                }
            }
        }
        else
        {
            Session["RandRFromReportFromDate"] = DateFrom.DateValue.ToString();
            Session["RandRFromReportToDate"] = DateTo.DateValue.ToString();
            Session["RandRFromReportFromDate"] = null;
            Session["RandRFromReportToDate"] = null;
        }
    }

    private void SetReportPath()
    {
    }
    private void SetReportParameters()
    {
        try
        {

            if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null || DateTo.DateValue.Length == 0 || DateTo.DateValue == null)
            {
                if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null)
                {
                    lblDateValidation.Visible = true;
                    DateFrom.Focus();
                }
                if (DateTo.DateValue.Length == 0 || DateTo.DateValue == null)
                {
                    if (IsPostBack)
                    {
                        lblDateValidation2.Visible = true;
                        DateTo.Focus();
                    }
                }
           
            }
            else
            {
                DateTime? startDate = null;
                DateTime? endDate = null;
                lblDateValidation.Visible = false;
                lblDateValidation2.Visible = false;

                if (DateFrom.DateValue.Length > 0 && DateTo.DateValue.Length > 0)
                {
                    if (Convert.ToDateTime(DateTo.DateValue) < Convert.ToDateTime(DateFrom.DateValue))
                    {
                        lblDateValidation3.Visible = true;
                        DateFrom.Focus();
                    }else
                    {
                        lblDateValidation3.Visible = false;
                    }

                    if (DateFrom.DateValue != null)
                    {
                        startDate = Convert.ToDateTime(DateFrom.DateValue);
                    }
                    if (DateTo.DateValue != null)
                    {
                        endDate = Convert.ToDateTime(DateTo.DateValue);
                    }
                    PopulateRdgrdPatTreatmentOnDataSource(startDate, endDate);
                }
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Get() ReportData");
        }
    }
    #region Private Methods

    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        string myrolename = _currentUser.RoleName.ToString();
        if (myrolename.IndexOf("TBI Rehabilitation and Polytrauma Clinicians") > -1)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    private void EnableButtonRunReport()
    {
        try
        {
            ButtonRunReport.Enabled = true;
            //mngBtnWordExcel.Enabled = true;
            //mngBtnExportPDF.Enabled = true;
            //mngBtnExportWord.Enabled = true;
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "private Fucntion EnableButtonRunReport()");
        }
    }



    #endregion


    protected void rdgrdPatTreatment_ItemDataBound(object sender, GridItemEventArgs e)
    {
        RadAjaxLoadingPanel1.EnableAjaxSkinRendering = true;
 
    }
    protected void rgGetRRPatients_ItemDataBound(object sender, GridItemEventArgs e)
    {
        RadAjaxLoadingPanel1.EnableAjaxSkinRendering = true;

    }

    protected void rgGetRRPatients_PageIndexChanged(object sender, GridPageChangedEventArgs e)
    {
        RadAjaxLoadingPanel1.EnableAjaxSkinRendering = true;
    }

    protected void rdgrdPatTreatment_PageIndexChanged(object sender, GridPageChangedEventArgs e)
    {
        RadAjaxLoadingPanel1.EnableAjaxSkinRendering = true;
    }
}

